from django.urls import path
from . import views

app_name = 'tasks'

urlpatterns = [
    # Task views
    path('', views.TaskListView.as_view(), name='task-list'),
    path('create/', views.TaskCreateView.as_view(), name='task-create'),
    path('<int:pk>/', views.TaskDetailView.as_view(), name='task-detail'),
    path('<int:pk>/update/', views.TaskUpdateView.as_view(), name='task-update'),
    path('<int:pk>/delete/', views.TaskDeleteView.as_view(), name='task-delete'),
    path('<int:pk>/complete/', views.TaskCompleteView.as_view(), name='task-complete'),
    
    # Comment views
    path('<int:pk>/comment/', views.add_comment, name='add-comment'),
    path('comments/<int:pk>/delete/', views.delete_comment, name='delete-comment'),
    
    # Attachment views
    path('<int:pk>/attach/', views.upload_attachment, name='upload-attachment'),
    path('attachments/<int:pk>/delete/', views.delete_attachment, name='delete-attachment'),
    
    # Task approval
    path('<int:pk>/approve/', views.TaskApprovalView.as_view(), {'action': 'approve'}, name='task-approve'),
    path('<int:pk>/reject/', views.TaskApprovalView.as_view(), {'action': 'reject'}, name='task-reject'),
    
    # Task assignment
    path('assign/', views.TaskAssignmentView.as_view(), name='task-assign'),
    
    # API endpoints
    path('api/tasks/', views.TaskListAPIView.as_view(), name='api-task-list'),
    path('api/tasks/<int:pk>/', views.TaskDetailAPIView.as_view(), name='api-task-detail'),
    path('api/tasks/<int:pk>/status/', views.TaskStatusUpdateAPIView.as_view(), name='api-task-status-update'),
]
